/*
 *  Kod z ksiki
 *  Programowanie w jzyku C. FAQ
 *  Addison-Wesley, 1996, ISBN 0-201-84519-9
 *  (pytanie 13.7)
 *
 *  Oparte na kodzie Arjana Kentera, wysanego na grup comp.lang.c
 *  13-01-1995 (message-id <3f65s7$li9@utrhcs.cs.utwente.nl>)
 *
 *  Ten kod moe by dowolnie uywany lub modyfikowany, bd wdziczny 
 *  za podanie rda. Nie daj jednak adnej gwarancji jego dziaania, 
 *  ani nie przyjmuj adnej odpowiedzialnoci za skutki jego 
 *  wykorzystania.
 *
 *  #define MAIN for a standalone test version, which reads
 *  lines consisting of a pattern and a string, printing "yes"
 *  if they match.
 *
 *  Uyj #define MAIN, aby skompilowa wersj testow, ktra wczytuje 
 *  wiersze, skadajce si z wzorca i napisu, a nastpnie wypisuje 
 *  "tak", jeeli napis pasuje do wzorca.
 */

int match(char *pat, char *str)
{
	switch(*pat) {
	case '\0':  return !*str;
	case '*':   return match(pat+1, str) ||
				*str && match(pat, str+1);
	case '?':   return *str && match(pat+1, str+1);
	default:    return *pat == *str && match(pat+1, str+1);
	}
}

#ifdef MAIN

#include <stdio.h>

#define MAXLINE 100

#ifdef __STDC__
extern int getline(FILE *, char *, int);
extern int makeargv(char *, char *[], int);
#endif

main()
{
char line[MAXLINE];
char *av[3];

while(getline(stdin, line, MAXLINE) != EOF)
	{
	if(makeargv(line, av, 3) < 2)
		continue;
	printf("%s\t%s\t%s\n", av[0], av[1], match(av[0], av[1]) ? "tak" : "nie");
	}

return 0;
}

#endif
